#!/bin/sh
TP_INPUTBOX_RESULT_NULL="DTAS[TUI]@{NULL}"
TP_INPUTBOX_RESULT_DATA=""

TP_INPUTBOX_RESULT_OK="DTAS[TUI]@{OK}"
TP_INPUTBOX_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_INPUTBOX_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_INPUTBOX_RESULT_CODE=""

TP_INPUTBOX_RESULT_MSG=""

tp_inputbox() {
    #debug_print "${0}" "${LINENO}" 'in function "tp_inputbox"'
    
    local title="${1}"
    local text="${2}"
    local ok_label="${3}"
    local cancel_label="${4}"
    local init_text="${5}"

    exec 3>&1
    local ret
    ret=`dialog \
            --title        "${title}" \
            --backtitle    "${CONS_BACK_TITLE}" \
            --ok-label     "${ok_label}" \
            --cancel-label "${cancel_label}" \
            --inputbox     "${text}" \
                           "${CONS_BOX_HEIGHT}" \
                           "${CONS_BOX_WIDTH}" \
                           ${init_text} \
            2>&1 1>&3; \
            case "${?}" in \
                1|255) echo "${TP_INPUTBOX_RESULT_CANCEL}" ;; \
            esac`
    exec 3>&-
    
    ##################################################
    # press "CANCEL" or "ESC"
    ##################################################
    case "${ret}" in
        "${TP_INPUTBOX_RESULT_CANCEL}" )
            TP_INPUTBOX_RESULT_CODE="${TP_INPUTBOX_RESULT_CANCEL}"
            TP_INPUTBOX_RESULT_DATA="${TP_INPUTBOX_RESULT_NULL}"
            TP_INPUTBOX_RESULT_MSG=""
            return
            ;;
    esac

    TP_INPUTBOX_RESULT_CODE="${TP_INPUTBOX_RESULT_OK}"
    TP_INPUTBOX_RESULT_DATA="${ret}"
    TP_INPUTBOX_RESULT_MSG=""
    return
}

